﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using Gemini.Core.JSON.LitJson;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{

    public class GExerciseData_UzupelnianieLukI : GExerciseData
    {
        public class ExerciseDataStub : IExerciseDataStub
        {
            public ExerciseDataStub()
            {
                options = new List<string>();
                correct = new List<int>();
                answers = new List<int>();
            }

            public int id { get; set; }
            public string text { get; set; }
            public List<string> options { get; set; }
            public List<int> correct { get; set; }
            public List<int> answers { get; set; }
        }

        private List<ExerciseDataStub> _listStub = null;
        public List<ExerciseDataStub> ExerciseData
        {
            get
            {
                if (_listStub == null)
                {
                    _listStub = new List<ExerciseDataStub>();
                }
                return _listStub;
            }
        }

        public GExerciseData_UzupelnianieLukI(ZSBELearning BLP, BL.ZSBELearning.ContextParam ContextParam)
            : base(BLP, ContextParam)
        { }

        public void Load()
        {
            if (ContextParam.ExerciseOut != null)
            {
                switch (ContextParam.ExerciseOut.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Section: MovingBox_SectionLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Text: MovingBox_TextLoad(ContextParam.ExerciseOut); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_MovingBox: Questions_MovingBoxLoad(ContextParam.ExerciseOut); break;
                }
            }
        }

        public void Check(List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            if (ContextParam.ExerciseIn != null)
            {
                switch (ContextParam.ExerciseIn.Type)
                {
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Section: MovingBox_SectionCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.MovingBox_Text: MovingBox_TextCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                    case GM.N610.ELearning.BL.Dictionary.Exercise.Types.Questions_MovingBox: Questions_MovingBoxCheck(ContextParam.ExerciseIn, ListExerciseDataSave); break;
                }

                SetExerciseOwlSave();
            }
        }

        private void MovingBox_SectionLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;
            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);


            foreach (XmlNode _loopXmlQuestion in _listXmlSection)
            {
                _stubIndex++;
                _optionsCounter = 0;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<string>();
                _loopStub.correct = new List<int>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _optionsCounter++;
                        _sbText.Append(Dictionary.OPEN_GAP);
                        _loopStub.options.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                        _loopStub.correct.Add(_optionsCounter);
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);   
            }

            AddExtraBox(Exercise, _stubIndex);
        }

        private void MovingBox_TextLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 1;

            StringBuilder _sbText = new StringBuilder();
            ExerciseDataStub _loopStub = new ExerciseDataStub();
            _loopStub.id = _stubIndex;
            _loopStub.options = new List<string>();
            _loopStub.correct = new List<int>();

            int _optionsCounter = 0;

            XmlNode _xmlExercise_Text = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Exercise_Text);

            foreach (XmlNode _loopXml in _xmlExercise_Text.ChildNodes)
            {
                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                {
                    _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                }

                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                {
                    _optionsCounter++;
                    _sbText.Append(Dictionary.OPEN_GAP);
                    _loopStub.options.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    _loopStub.correct.Add(_optionsCounter);
                }
            }

            _loopStub.text = _sbText.ToString();
            ExerciseData.Add(_loopStub);

            AddExtraBox(Exercise, _stubIndex);
        }

        private void Questions_MovingBoxLoad(PI.GM.N610.ELearning.BL.BO.Exercise Exercise)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;
            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                _stubIndex++;
                _optionsCounter = 0;

                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = _stubIndex;
                _loopStub.options = new List<string>();
                _loopStub.correct = new List<int>();

                StringBuilder _sbText = new StringBuilder();

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Text)
                    {
                        _sbText.Append(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                    }

                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        _optionsCounter++;
                        _sbText.Append(Dictionary.OPEN_GAP);
                        _loopStub.options.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXml));
                        _loopStub.correct.Add(_optionsCounter);
                    }
                }

                _loopStub.text = _sbText.ToString();

                ExerciseData.Add(_loopStub);
            }

            AddExtraBox(Exercise, _stubIndex);
        }

        private void MovingBox_SectionCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            int _stubIndex = 0;
            int _optionsCounter = 0;

            Exercise.TmpPoints = 0;

            XmlNode _xmlSections = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Sections);
            XmlNodeList _listXmlSection = _xmlSections.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Section);
            

            foreach (XmlNode _loopXmlQuestion in _listXmlSection)
            {
                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex+1;
                _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], _loopXml))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }

        private void MovingBox_TextCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;
            int _optionsCounter = 0;

            XmlNode _xmlExercise_Text = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Exercise_Text);

            GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
            GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
            _loopExerciseCheck.id = _stubIndex++;

            foreach (XmlNode _loopXml in _xmlExercise_Text.ChildNodes)
            {
                if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                {
                    if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], _loopXml))
                    {
                        Exercise.TmpPoints++;
                        _loopExerciseCheck.success_arr.Add(true);
                    }
                    else
                    {
                        _loopExerciseCheck.success_arr.Add(false);
                    }

                    _optionsCounter++;
                }
            }

            ExerciseCheck.Add(_loopExerciseCheck);
        }

        private void Questions_MovingBoxCheck(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, List<GExerciseDataCheckOne> ListExerciseDataSave)
        {
            Exercise.TmpPoints = 0;

            int _stubIndex = 0;
            int _optionsCounter = 0;

            XmlNode _xmlQuestions = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Questions);
            XmlNodeList _listXmlQuestion = _xmlQuestions.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Question);


            foreach (XmlNode _loopXmlQuestion in _listXmlQuestion)
            {
                GExerciseDataCheckOne _loopExerciseDataSave = ListExerciseDataSave[_stubIndex];
                GExerciseCheck _loopExerciseCheck = new GExerciseCheck();
                _loopExerciseCheck.id = _stubIndex++;
                _optionsCounter = 0;

                foreach (XmlNode _loopXml in _loopXmlQuestion.ChildNodes)
                {
                    if (_loopXml.Name == PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box)
                    {
                        if (BLP.BLELearning.Utility.IsAnswerCorrect(_loopExerciseDataSave.answers[_optionsCounter], _loopXml))
                        {
                            Exercise.TmpPoints++;
                            _loopExerciseCheck.success_arr.Add(true);
                        }
                        else
                        {
                            _loopExerciseCheck.success_arr.Add(false);
                        }

                        _optionsCounter++;
                    }
                }

                ExerciseCheck.Add(_loopExerciseCheck);
                _stubIndex++;
            }
        }

        private void AddExtraBox(PI.GM.N610.ELearning.BL.BO.Exercise Exercise, int StubIndex)
        {
            XmlNode _xmlExtraBox = Exercise.XML.DocumentElement.SelectSingleNode(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Extra_Box);
            XmlNodeList _listXmlExtraBox = _xmlExtraBox.SelectNodes(PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLNodes.Box);

            if (_listXmlExtraBox.Count > 0)
            {
                StubIndex++;
                ExerciseDataStub _loopStub = new ExerciseDataStub();
                _loopStub.id = StubIndex;
                _loopStub.text = String.Empty;

                foreach (XmlNode _loopXmlExtraBox in _listXmlExtraBox)
                {
                    _loopStub.options.Add(Gemini.Utility.XML.Node.Get.CDATA(_loopXmlExtraBox, String.Empty));
                }

                ExerciseData.Add(_loopStub);
            }
        }
    }

}
